
<?php


include('config.php');

?>
<!DOCTYPE html>

<html>

<body>

<form id="form" action="" method="POST">

  <fieldset>

    Upload File: <input type="file" class="video_upload" name="image">
    <br>

    <input type="button" id="submit_btn" name="submit" value="submit">
    <div id="bar-5" class="bar-main-container" style="display:none;">
        <div class="wrap">
            <div class="bar-percentage">0%</div>
            <div class="bar-container">
                <div class="bar"></div>
            </div>
        </div>
    </div>
  </fieldset>
    <div class="uploadError" style="display:none;width:100%;color:#ff0000;"><span></span></div>
  <div id="alert_div"></div>
  <div class="processor"></div>
  <div class="uploadeddiv_btn" style="display:none;"> Uploading started</div>

</form>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>

<script>

    
$(document).on("click", "#submit_btn", function(e) {
    e.preventDefault();

    var forms = new FormData();

    var other_data = $("#form").serializeArray();
    $.each(other_data, function(key, input) {
        forms.append(input.name, input.value);
    });

    
    var file_data = $('.video_upload').prop('files')[0];
    
    $.ajax({
        type: "POST",
        url: "<?php echo "http://" . $_SERVER['SERVER_NAME'] . $_SERVER['REQUEST_URI']; ?>api.php?type=add",
        data: forms,
        dataType: 'json',
        cache: false,
        contentType: false,
        processData: false,
        success: function(response) {
            console.log(response.status);
            if (response.status == true || response.status == "true") {
                if (!response.id) {
                    $('#alert_div').empty().show().html('<div class="alert alert-success alert-dismissible fade show" role="alert"><h4 class="alert-heading">Well done!</h4><p>' + response.message + '</p></div>');
                    $('.processor').html('<i class="fa fa-check"></i> Done');
                } else {
                    $(".uploadeddiv_btn").show();
                    // Video Uploading Code Start

                    var filename = Date.now() + '.' + file_data.name.split('.').pop();
                    $('.processor').hide();
                    var newForm = new FormData();

                    newForm.append('acl', 'private');
                    newForm.append('success_action_status', 201);
                    newForm.append('policy', response.data.policy);
                    newForm.append('X-amz-credential', response.data.amz_credential);
                    newForm.append('X-amz-date', response.data.amz_date);
                    newForm.append('X-amz-algorithm', response.data.amz_algorithm);
                    newForm.append('X-amz-expires', response.data.amz_expires);
                    newForm.append('X-amz-signature', response.data.amz_signature);
                    newForm.append('Content-Type', file_data.type);
                    newForm.append('key', response.data.key + filename);
                    newForm.append('file', file_data);

                    // header("Access-Control-Allow-Origin: *");
                    // header('Access-Control-Allow-Origin: *');
                    // header('Access-Control-Allow-Methods: POST, GET, OPTIONS');
                    // header('Access-Control-Allow-Headers: *');
                    // header('Access-Control-Max-Age: 1728000');
                    // header("Content-Length: 0");
                    // header("Content-Type: text/plain"); 

                    uploadingRe = $.ajax({
                        url: response.data.url,
                        type: 'post',
                        datatype: 'xml',
                        data: newForm,
                        contentType: false,
                        processData: false,
                        crossDomain: true,
                        headers: {
                            'Access-Control-Allow-Origin': '*'
                        },
                        xhr: function() {
                            var xhr = $.ajaxSettings.xhr();
                            if (xhr.upload) {
                                xhr.upload.addEventListener('progress', function(event) {
                                    var percent = 0;
                                    var position = event.loaded || event.position;
                                    var total = event.total;
                                    if (event.lengthComputable) {
                                        $("#bar-5").show();
                                        percent = Math.ceil(position / total * 100);
                                        $(".bar-percentage").text(percent + "%");
                                        $(".bar-container").find(".bar").css("width", +percent + "%");
                                    }
                                }, true);
                            }
                            return xhr;
                        },
                        success: (function(res) {
                            console.log(res);
                            
                                var url = $(res).find("Location").text();
                                forms.append("url", url);
                                forms.append("id", response.id);
                                forms.append("original_file_name", file_data.name);

                                $.ajax({
                                    url: "<?php echo "http://" . $_SERVER['SERVER_NAME'] . $_SERVER['REQUEST_URI']; ?>api.php?type=update",
                                    type: "post", //request type,
                                    dataType: 'json',
                                    data: forms,
                                    cache: false,
                                    contentType: false,
                                    processData: false,
                                    success: function(result) {
                                        if (result.status == true) {
                                            $('#alert_div').empty().show().html('<div class="alert alert-alert-success alert-dismissible fade show" role="alert"><h4 class="alert-heading">Well done!</h4><p>Successfully Uploaded!</p></div>');
                                            $('.processor').html('<i class="fa fa-check"></i> Done');
                                            $(".uploadeddiv_btn").find(".uplading").find("i").removeClass("fa-spin").removeClass("fa-spinner").addClass("fa-check-circle");
                                            $(".uploadeddiv_btn").find(".uplading").css("color", "green");
                                        } else {
                                            $('#alert_div').empty().show().html('<div class="alert alert-warning">Something went wrong!</div>');
                                            $(".uploadeddiv_btn").find(".uplading").find("i").removeClass("fa-spin").removeClass("fa-spinner").addClass("fa fa-");
                                            $(".uploadeddiv_btn").find(".uplading").css("color", "red");
                                        }
                                        
                                        $(".uploadeddiv_btn").hide();

                                    }
                                });
                            }),
                        error: (function() {
                                $('#alert_div').empty().show().html('<div class="alert alert-warning">Video Upload Failed</div>');
                                $(".uploadeddiv_btn").find(".uplading").find("i").removeClass("fa-spin").removeClass("fa-spinner").addClass("fa fa-");
                                $(".uploadeddiv_btn").find(".uplading").css("color", "red");
                                $(".bar-main-container").hide()
                                $(".created_btn").show();
                                $(".created_btn").find("button").show();
                                $(".created_btn").find("button").html("create");
                                $(".uploadeddiv_btn").hide();
                                $(".uploadeddiv_btn").find(".progress_custom").find("i").addClass("fa-spin").addClass("fa-spinner");
                                $(".uploadeddiv_btn").find(".uplading").css("color", "");
                            })
                    }); // End 
                }

            } else {
                $('#alert_div').empty().show().html('<div class="alert alert-warning">' + response.message + '</div>');
            }
        }
    });
});

</script>

</body>

</html>