<?php  
session_start();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Costco</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-EVSTQN3/azprG1Anm3QDgpJLIm9Nao0Yz1ztcQTwFspd3yD65VohhpuuCOmLASjC" crossorigin="anonymous">
    <link rel="stylesheet" href="style.css">
</head>
<body>
 <!-- navbar start from here -->
 <nav class="navbar navbar-expand-lg navbar-light bg-light">
    <div class="container-fluid">
      <a class="navbar-brand" href="index.php"><img src="img/logo.png" alt=""></a>
      <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
        <span class="navbar-toggler-icon"></span>
      </button>
      <div class="collapse navbar-collapse" id="navbarSupportedContent">
        <ul class="navbar-nav ms-auto mb-2 mb-lg-0">
          <li class="nav-item">
            <a class="nav-link" aria-current="page" href="index.php">Home</a>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="apply.php">Apply</a>
          </li>
        </ul>
        
      </div>
    </div>
  </nav>
  <div class="mt-2">
<?php
if(isset($_SESSION['message'])): ?>
   <div class="alert alert-success">
       <?php echo $_SESSION['message']; ?>

   </div>
   <?php unset($_SESSION['message']); ?>
<?php endif; ?>


<?php
if(isset($_SESSION['error'])): ?>
   <div class="alert alert-dangar">
       <?php echo $_SESSION['error']; ?>

   </div>
   <?php unset($_SESSION['error']); ?>
<?php endif; ?>

</div>
    
<!-- hero section start from here -->
<div class="heroSec">
    <div class="container-fluid">
        <div id="carouselExampleControls" class="carousel slide" data-bs-ride="carousel">
            <div class="carousel-inner">
              <div class="carousel-item active">
                <img src="img/img1.jpg" class="d-block w-100 img-fluid" alt="...">
              </div>
              <div class="carousel-item">
                <img src="img/img2.jpg" class="d-block w-100 img-fluid" alt="...">
              </div>
            </div>
            <button class="carousel-control-prev" type="button" data-bs-target="#carouselExampleControls" data-bs-slide="prev">
              <span class="carousel-control-prev-icon" aria-hidden="true"></span>
              <span class="visually-hidden">Previous</span>
            </button>
            <button class="carousel-control-next" type="button" data-bs-target="#carouselExampleControls" data-bs-slide="next">
              <span class="carousel-control-next-icon" aria-hidden="true"></span>
              <span class="visually-hidden">Next</span>
            </button>
          </div>
        <!-- <img src="img/homepage-bg.jpg" class="img-fluid" alt=""> -->
    </div>
</div>
<!-- second section start from here -->
<div class="secondSec">
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <h3>Did You Know?</h3>
                <p>Costco Wholesale is a multi-billion dollar global retailer with warehouse club operations in eight countries. We are the recognized leader in our field, dedicated to quality in every area of our business and respected for our outstanding business ethics. Despite our large size and explosive international expansion, we continue to provide a family atmosphere in which our employees thrive and succeed. We are proud to have been named by Washington CEO Magazine as one of the top three companies to work for in the state of Washington.</p>
                <a href="apply.php"> <button type="button" class="btn btn-dark">APPLY HERE</button> </a>
            </div>
            <div class="col-md-12">
                <h4>What Is Costco?</h4>
                <p>Costco is a membership warehouse club, dedicated to bringing our members the best possible prices on quality brand-name merchandise. With hundreds of locations worldwide, Costco provides a wide selection of merchandise, plus the convenience of specialty departments and exclusive member services, all designed to make your shopping experience a pleasurable one..</p>
            </div>
            <div class="col-md-12">
                <h4>The History of Costco</h4>
                <p>
                The company's first location, opened in 1976 under the Price Club name, was in a converted airplane hangar on Morena Boulevard in San Diego. Originally serving only small businesses, the company found it could achieve far greater buying clout by also serving a selected audience of non-business members. With that change, the growth of the warehouse club industry was off and running. In 1983, the first Costco warehouse location was opened in Seattle. Costco became the first company ever to grow from zero to $3 billion in sales in less than six years. When Costco and Price Club merged in 1993, the combined company, operating under the name PriceCostco, had 206 locations generating $16 billion in annual sales.
</p><p>
Our operating philosophy has been simple. Keep costs down and pass the savings on to our members. Our large membership base and tremendous buying power, combined with our never-ending quest for efficiency, result in the best possible prices for our members. Since resuming the Costco name in 1997, the company has grown worldwide with total sales in recent fiscal years exceeding $64 billion. For additional information about Costco, download the Costco Story in a PDF format to learn more.
</p><p>
Costco has transformed the retail world. When entrepreneur Sol Price introduced a groundbreaking retail concept in San Diego, California. Price Club was the world's first membership warehouse club, a place where efficient buying and operating practices gave members access to unmatched savings.
</p><p>
At first, Price Club was limited exclusively to business members, who could purchase a wide range of supplies and wholesale items. Jim Sinegal, the executive vice-president of merchandising, distribution and marketing, was instrumental in fine-tuning the merchandise and marketing strategies, helping to turn Price Club into a success story that changed the face of retailing worldwide.
</p><p>
Seven years later, Jim Sinegal channeled his expertise into co-founding Costco Wholesale with Jeff Brotman, and together they opened the first warehouse in Seattle, Washington in 1983.
</p><p>
Over the next decade, both Price Club and Costco Wholesale continued to innovate and grow, and in 1993, the two mega-retailers merged, creating a gifted leadership team that soon made Costco the world's most successful warehouse club.
</p><p>
Today, as the company evolves, it stays true to the qualities that helped attract and retain millions of loyal members around the globe:
</p><p>
Commitment to quality. Costco warehouses carry about 4,000 SKUs (stock keeping units) compared to the 30,000 found at most supermarkets. By carefully choosing products based on quality, price, brand, and features, the company can offer the best value to members.
</p><p>
Entrepreneurial spirit. Throughout the decades, the entrepreneurial drive for excellence has continued to define Costco staff at every level. From its management team to the people on the warehouse floor, everyone is united in a common goal to exceed member expectations.
</p><p>
Employee focus. Costco is often noted for being much more employee-focused than other Fortune 500 companies. By offering fair wages and top-notch benefits, the company has created a workplace culture that attracts positive, high-energy, talented employees.
                </p>
            </div>
        </div>
    </div>
</div>

<!-- third section start from here -->
<div class="thirdSec">
    <div class="thirdSecBg">
        <div class="container">
            <div class="col-md-6">
                <h3 style="color: #fff;">MORE ABOUT COSTCO</h3>
                <div class="accordion accordion-flush" id="accordionFlushExample">
                    <div class="accordion-item">
                      <h2 class="accordion-header" id="flush-headingOne">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#flush-collapseOne" aria-expanded="false" aria-controls="flush-collapseOne">
                        Costco Welcomes Veterans
                        </button>
                      </h2>
                      <div id="flush-collapseOne" class="accordion-collapse collapse" aria-labelledby="flush-headingOne" data-bs-parent="#accordionFlushExample">
                        <div class="accordion-body">
                        <p>Costco Wholesale values the contributions that you have made and the experiences you have gained in service to our country. We're looking for people with a passion for the retail industry who are able to provide great leadership. Your experience, coupled with our fast-paced environment, could lead to an exciting career.
</p><p>
For those completing service both at home and overseas, and are using the G.I. Bill to attend school, Costco offers flexible part-time hours complete with competitive wages and great benefits. The retail industry is a challenging career path for anyone, and Costco is proud to support our veterans with career opportunities.
</p><p>
For the Detroit, Chicago, Kansas City and Minneapolis markets, please send your resume to Jenny Diguardi at Jdiguardi@costco.com.</p>
                        </div>
                      </div>
                    </div>
                    <div class="accordion-item">
                      <h2 class="accordion-header" id="flush-headingTwo">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#flush-collapseTwo" aria-expanded="false" aria-controls="flush-collapseTwo">
                        Inclusion at Costco
                        </button>
                      </h2>
                      <div id="flush-collapseTwo" class="accordion-collapse collapse" aria-labelledby="flush-headingTwo" data-bs-parent="#accordionFlushExample">
                        <div class="accordion-body">
                        It always has been and continues to be Costco's policy that employees should be able to enjoy a work environment free from all forms of unlawful employment discrimination. All decisions regarding recruiting, hiring, promotion, assignment, training, termination, and other terms and conditions of employment will be made without unlawful discrimination on the basis of race, color, national origin, ancestry, sex, sexual orientation, gender identity or expression, religion, age, pregnancy, disability, work-related injury, covered veteran status, political ideology, genetic information, marital status, or any other factor that the law protects from employment discrimination.
                        </div>
                      </div>
                    </div>
                    
                  </div>
            </div>
            <div class="col-md-6"></div>
        </div>
    </div>
</div>

<!-- footer section start from here -->
<div class="footer">
    <div class="container">
        <div class="row">
            <div class="col-md-4">
                <h4>About Costco</h4>
                <p>
                Costco Wholesale is a multi-billion dollar global retailer with warehouse club operations in eight countries. We are the recognized leader in our field, dedicated to quality in every area of our business and respected for our outstanding business ethics. Despite our large size and explosive international expansion, we continue to provide a family atmosphere in which our employees thrive and succeed. We are proud to have been named by Washington CEO Magazine as one of the top three companies to work for in the state of Washington.

                </p>
            </div>
            <div class="col-md-4">
                <h4>Connect with us</h4>
                <a style="text-decoration: none; color: #fff;" href="#"> <span>Instagram</span> </a> <br>
                <a style="text-decoration: none; color: #fff;" href="#"> <span>Facebook</span> </a> <br>
                <a style="text-decoration: none; color: #fff;" href="#"> <span>Twitter</span> </a> <br>
                <a style="text-decoration: none; color: #fff;" href="#"> <span>Linkedin</span> </a>
            </div>
            <div class="col-md-4">
                <h4>Quick Links</h4>
                <a style="text-decoration: none; color: #fff;" href="#"> <span>SHOP VEHICLES</span> </a> <br>
                <a style="text-decoration: none; color: #fff;" href="#"> <span>FINANCING INFO</span> </a> <br>
                <a style="text-decoration: none; color: #fff;" href="#"> <span>CONTACT US</span> </a> <br>
            </div>
        </div>
    </div>
</div>



    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.2/dist/umd/popper.min.js" integrity="sha384-IQsoLXl5PILFhosVNubq5LC7Qb9DXgDA9i+tQ8Zj3iwWAwPtgFTxbJ8NT4GN1R8p" crossorigin="anonymous"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/js/bootstrap.min.js" integrity="sha384-cVKIPhGWiC2Al4u+LWgxfKTRIcfu0JTxR+EQDz/bgldoEyl4H0zUF0QKbrJ0EcQF" crossorigin="anonymous"></script>
</body>
</html>