<?php
namespace UnitTestFiles\Test;
use PHPUnit\Framework\TestCase;

class PythonFileTest extends TestCase
{
    /**
     * @dataProvider additionProvider
     */
    public function testAdd($val, $expected)
    {
        $random = substr(md5(mt_rand()), 0, 7);
        $input_code = 'user_input = "' . $val . '"; ';
        
        $filePath = "/var/www/html/ide/temp/unit_" . $random. ".python";
        $unitTestfilePath = "/var/www/html/ide/temp/python_test.python";
        $code = file_get_contents($unitTestfilePath);
        $programFile = fopen($filePath, "w");
        fwrite($programFile, $input_code . $code);
        fclose($programFile);

        $output = shell_exec("/usr/bin/python3 $filePath 2>&1");
        $output= str_replace("\n","",$output);
        $expected= str_replace("\n","",$expected);
        
        $this->expectOutputString($expected);
        print $output;
        unlink($filePath);
    }

    public function additionProvider()
    {
        return [
            ["jimmy", "ymmij"],
            ["robert", "trebor"],
            ["bill", "llib"],
        ];
    }
}

?>