<?php
namespace UnitTestFiles\Test;
use PHPUnit\Framework\TestCase;
session_start();

class PHPFileTest extends TestCase
{
    /**
     * @dataProvider additionProvider
     */
    public function testAdd($val, $expected)
    {
        $match_val = $val;
        $random = substr(md5(mt_rand()), 0, 7);
        $input_code = '<?php 
        $user_input = "' . $val . '";';
        $filePath = "/var/www/html/ide/temp/unit_" . $random. ".php";
        $unitTestfilePath = "/var/www/html/ide/temp/php_test.php";
        $code = file_get_contents($unitTestfilePath);
        $programFile = fopen($filePath, "w");
        fwrite($programFile, $input_code . $code);
        fclose($programFile);
        $get = require($filePath);
        $this->expectOutputString($expected);
        unlink($filePath);
        // shell_exec("del ".$filePath." ");
        // $this->assertEquals($expected, $match_val);
    }

    public function additionProvider()
    {
        $url = "https://reviewnprep.com/get-ide-test-cases/" . $_SESSION['record_id'];
        $response = $this->callApi($url,[]);
        if ($response->status == true) {
            $result = (array)$response->data;
            return (array)$result;
        } else {
            return [];
        }
    }

    public function callApi($url, $data, $isReturnJson = 1)
    {
        try {
            $postvars = '';
            foreach ($data as $key => $value) {
                $postvars .= $key . "=" . $value . "&";
            }

            $ch = curl_init();

            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

            $server_output = curl_exec($ch);
            // print_r($server_output);exit;
            curl_close($ch);
            $result = json_decode($server_output);
            if ($isReturnJson == 1) {
                return $result;
            } else {
                return $server_output;
            }
        } catch (\Exception $e) {
            echo 'Message: ' . $e->getMessage();
            exit;
            return false;
        }
    } 
}

?>