<?php
namespace UnitTestFiles\Test;
use PHPUnit\Framework\TestCase;

class PythonFileTest extends TestCase
{
    /**
     * @dataProvider additionProvider
     */
    public function testAdd($val, $expected)
    {
        $random = substr(md5(mt_rand()), 0, 7);
        $input_code = 'user_input = "' . $val . '"; ';
        
        $filePath = "/var/www/html/ide/temp/unit_" . $random. ".python";
        $unitTestfilePath = "/var/www/html/ide/temp/python_test.python";
        $code = file_get_contents($unitTestfilePath);
        $programFile = fopen($filePath, "w");
        fwrite($programFile, $input_code . $code);
        fclose($programFile);

        $output = shell_exec("/usr/bin/python3 $filePath 2>&1");
        $output= (int)str_replace("\r\n","",$output);
        $expected= (int)str_replace("\r\n","",$expected);
        
        $this->expectOutputString($expected);
        print $output;
        unlink($filePath);
    }

    public function additionProvider()
    {
        return [
            ["1 1 1",3],
            ["15 15",30],
            ["25 25",50]
        ];
    }
}

?>