<?php
namespace UnitTestFiles\Test;
use PHPUnit\Framework\TestCase;

class CFileTest extends TestCase
{
    /**
     * @dataProvider additionProvider
     */
    public function testAdd($val, $expected)
    {
        $random = substr(md5(mt_rand()), 0, 7);
        $input_code = 'char user_input[] = "' . $val . '"; 
        ';
        
        $filePath = "/var/www/html/ide/temp/unit_" . $random. ".c";
        $unitTestfilePath = "/var/www/html/ide/temp/c_test.c";
        $code = file_get_contents($unitTestfilePath);
        $programFile = fopen($filePath, "w");
        fwrite($programFile, $input_code . $code);
        fclose($programFile);


        $outputExe = "/var/www/html/ide/temp/" . $random . ".exe";
        shell_exec("gcc $filePath -o $outputExe");

        $output = shell_exec("$outputExe 2>&1");
        $output= (int)str_replace("\r\n","",$output);
        $expected= (int)str_replace("\r\n","",$expected);
        
        $this->expectOutputString($expected);
        print $output;
        unlink($filePath);
    }

    public function additionProvider()
    {
        return [
            ["1 1 1",3],
            ["15 15",30],
            ["25 25",50]
        ];
    }
}

?>