<?php
namespace UnitTestFiles\Test;
use PHPUnit\Framework\TestCase;

class NodeFileTest extends TestCase
{
    /**
     * @dataProvider additionProvider
     */
    public function testAdd($val, $expected)
    {
        $random = substr(md5(mt_rand()), 0, 7);
        $input_code = 'let user_input = "' . $val . '";';
        
        $filePath = "/var/www/html/FFMPEG-CRON-JOB/ide/temp/unit_" . $random. ".js";
        $unitTestfilePath = "/var/www/html/FFMPEG-CRON-JOB/ide/temp/node_test.js";
        $code = file_get_contents($unitTestfilePath);
        $programFile = fopen($filePath, "w");
        fwrite($programFile, $input_code . $code);
        fclose($programFile);

        $output = shell_exec("node $filePath 2>&1");
        $output= str_replace("\n","",$output);
        $expected= str_replace("\n","",$expected);
        
        $this->expectOutputString($expected);
        print $output;
        unlink($filePath);
    }

    public function additionProvider()
    {
        return [
            ["jimmy", "ymmij"],
            ["robert", "trebor"],
            ["bill", "llib"],
        ];
    }
}

?>