<?php
namespace UnitTestFiles\Test;
use PHPUnit\Framework\TestCase;

class CppFileTest extends TestCase
{
    /**
     * @dataProvider additionProvider
     */
    public function testAdd($val, $expected)
    {
        $random = substr(md5(mt_rand()), 0, 7);
        $input_code = 'char* user_input = "' . $val . '"; 
        ';
        
        $filePath = "/var/www/html/FFMPEG-CRON-JOB/ide/temp/unit_" . $random. ".cpp";
        $unitTestfilePath = "/var/www/html/FFMPEG-CRON-JOB/ide/temp/cpp_test.cpp";
        $code = file_get_contents($unitTestfilePath);
        $programFile = fopen($filePath, "w");
        fwrite($programFile, $input_code . $code);
        fclose($programFile);


        $outputExe = "/var/www/html/FFMPEG-CRON-JOB/ide/temp/" . $random . ".exe";
        shell_exec("g++ $filePath -o $outputExe");

        $output = shell_exec("$outputExe 2>&1");
        $output= str_replace("\n","",$output);
        $expected= str_replace("\n","",$expected);
        
        $this->expectOutputString($expected);
        print $output;
        unlink($filePath);
    }

    public function additionProvider()
    {
        return [
            ["jimmy", "ymmij"],
            ["robert", "trebor"],
            ["bill", "llib"],
        ];
    }
}

?>